<?php

namespace xenarabia\AddUserTitle\XF\Template;

use XF\App;
use XF\Language;

class Templater extends XFCP_Templater
{
	protected $displayGroupIds = [];

	public function addDefaultHandlers()
	{
		parent::addDefaultHandlers();

		$this->addFunction('xenarabiacopyright', function ($templater, &$escape) {
			if (\XF::app()->offsetExists('XenarabiaCopyright') && \XF::app()->XenarabiaCopyright === true)
			{
				return '';
			}

			$escape = false;

			\XF::app()->XenarabiaCopyright = true;
			$xencopyright = \XF::phrase('xenarabiacopyright');
			return '<li><a href="https://xenarabia.com" class="u-concealed" dir="ltr" style="display: block" data-xf-init="tooltip" title="'.$xencopyright.'">
				XenArabia</a></li>';
		});
	}

}