<?php

namespace xenarabia\AddUserTitle\XF\Entity;

use XF\Mvc\Entity\Structure;

class User extends XFCP_User
{
    public static function getStructure(Structure $structure)
    {
        $structure = parent::getStructure($structure);
        $structure->relations['UserTitle'] = [
				'entity' => 'XF:User',
				'type' => self::TO_ONE,
				'conditions' => [['aut_id', '=', '$aut_id']],
				'primary' => true
        ];
      
        return $structure;   
    } 

    public function getUserTitles(\XF\Entity\User $user)
    {
        $usertitles = \XF::finder('xenarabia\AddUserTitle\XF:AddUserTitleEntity')
        // ->with('UserTitle')
        ->where('aut_id',$user->aut_id)
        ->fetch();

        return $usertitles;
    }
}
