<?php

namespace xenarabia\AddUserTitle\XF\Admin\Controller;

use XF\Mvc\FormAction;
use XF\Mvc\ParameterBag;
use XF\Mvc\Reply\View;
use XF\Admin\Controller\AbstractController;

use xenarabia\AddUserTitle\XF\Entity\AddUserTitleEntity;

class AddUserTitle extends AbstractController{

	public function actionIndex(ParameterBag $params)
	{
		$AuserTitles = $this->finder('xenarabia\AddUserTitle\XF:AddUserTitleEntity');
		$viewParams = [
			'AuserTitles'	=> $AuserTitles->fetch(),
			'total'	=> $AuserTitles->total()
		];
		return $this->view('xenarabia\AddUserTitle\XF:AddUserTitle\view', 'aut_view', $viewParams);
    }
    
    public function actionAdd()
	{
		$aut = $this->em()->create('xenarabia\AddUserTitle\XF:AddUserTitleEntity');
		return $this->autAdd($aut);
	}

    public function autAdd(AddUserTitleEntity $addUserTitleEntity)
	{
		$viewParams = [
			'AuserTitles'	=> $addUserTitleEntity
        ];
        // \XF::dump($GoAdds);
		return $this->view('xenarabia\AddUserTitle\XF:AddUserTitle\add', 'aut_add', $viewParams);
	}


	public function actionSave(ParameterBag $params)
	{
		$this->assertPostOnly();
		
		if ($params->aut_id)
		{
			$aut = $this->assertAutExists($params->aut_id);
            $form = $this->autAddEditSave($aut);
		}
		else
		{
            $aut = $this->em()->create('xenarabia\AddUserTitle\XF:AddUserTitleEntity');
            $form = $this->autAddEditSave($aut);
		}

        if(get_class($form) === 'XF\Mvc\Reply\Error') {
			return $form;
		} else {
			$form->run();
		}

		return $this->redirect($this->buildLink('addusertitle'), \XF::phrase('aut_has_been_saved'));
	}
	
	protected function autAddEditSave(AddUserTitleEntity $addUserTitleEntity)
	{
        $form = $this->formAction();
		$entityInput = $this->filter([
            'aut_user_title' => 'str', 
            'aut_user_title_css' => 'str'
        ]);

        $form->basicEntitySave($addUserTitleEntity, $entityInput);
		return $form;
	}

	public function actionEdit(ParameterBag $params)
	{
		$aut = $this->assertAutExists($params->aut_id);
		
		return $this->autEdit($aut);
	}

	protected function autEdit(AddUserTitleEntity $addUserTitleEntity)
	{
		$viewParams = [
			'AuserTitles'	=> $addUserTitleEntity
		];
		return $this->view('xenarabia\AddUserTitle\XF:AddUserTitle\add', 'aut_add', $viewParams);
	}

	public function actionDelete(ParameterBag $params)
	{
		$aut = $this->assertAutExists($params['aut_id']);
		// $options = \XF::options();
		$AuserTitles = $this->finder('xenarabia\AddUserTitle\XF:AddUserTitleEntity')
		->where('aut_id',$params['aut_id'])
		->fetchOne();

		/** @var \XF\ControllerPlugin\Delete $plugin */
		$plugin = $this->plugin('XF:Delete');
		//$entity, $confirmUrl, $contentUrl, $returnUrl, $contentTitle
		return $plugin->actionDelete(
			$AuserTitles,
			$this->buildLink('addusertitle/delete', $AuserTitles),
			$this->buildLink('addusertitle/edit', $AuserTitles),
			$this->buildLink('addusertitle'),
			$AuserTitles->aut_user_title
		);
	}
	
	protected function assertAutExists($id, $with = null, $phraseKey = null)
	{
		return $this->assertRecordExists('xenarabia\AddUserTitle\XF:AddUserTitleEntity', $id, $with, $phraseKey);
	}
	
}


?>