<?php

namespace xenarabia\AddUserTitle;

use XF\AddOn\AbstractSetup;
use XF\AddOn\StepRunnerInstallTrait;
use XF\AddOn\StepRunnerUninstallTrait;
use XF\AddOn\StepRunnerUpgradeTrait;

use XF\Db\Schema\Alter;
use XF\Db\Schema\Create;

class Setup extends AbstractSetup
{
	use StepRunnerInstallTrait;
	use StepRunnerUpgradeTrait;
	use StepRunnerUninstallTrait;

	public function installStep1()
    {
        $this->schemaManager()->alterTable('xf_user', function(Alter $table)
        {
            $table->addColumn('aut_id', 'varchar', 255)->setDefault(0);
		});
		
		$this->schemaManager()->createTable('xf_aut', function(Create $table)
		{
			$table->addColumn('aut_id', 'int')->autoIncrement();
			$table->addColumn('aut_user_title', 'varchar', 255);
			$table->addColumn('aut_user_title_css', 'text');
			$table->addPrimaryKey('aut_id');
		});
	}


	public function uninstall(array $stepParams = [])
	{
		$this->schemaManager()->alterTable('xf_user', function(Alter $table)
		{
			$table->dropColumns('aut_id', 'varchar');
		});

		$this->schemaManager()->dropTable('xf_aut');
	}
}